<?php
session_start();
if (!isset($_SESSION['autenticado']) || $_SESSION['autenticado']!==true) {
  header('Location: login.php');
  exit;
}
$mysqli = new mysqli('localhost:3306', 'usuario_db', 'clave_db', 'nombre_bd');
if ($mysqli->connect_error) {
  die('Error conexión BD: '.$mysqli->connect_error);
}
$msg='';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $titulo = $_POST['titulo'] ?? '';
  $contenido = $_POST['contenido'] ?? '';
  if ($titulo && $contenido) {
    $stmt = $mysqli->prepare("INSERT INTO comunicados (titulo, contenido) VALUES (?, ?)");
    $stmt->bind_param('ss', $titulo, $contenido);
    $stmt->execute();
    $stmt->close();
    $msg = 'Comunicado agregado correctamente.';
  }
}
$result = $mysqli->query("SELECT * FROM comunicados ORDER BY fecha DESC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Gestión de Comunicados - SSR La Aguada</title>
  <link rel="stylesheet" href="css/estilos.css" />
</head>
<body>
  <h1>Gestión de Comunicados</h1>
  <p><a href="logout.php">Cerrar sesión</a></p>
  <?php if ($msg): ?>
    <p style="color:green;"><?= htmlspecialchars($msg) ?></p>
  <?php endif; ?>
  <form method="post" action="admin_comunicados.php" autocomplete="off">
    <label for="titulo">Título:</label><br />
    <input type="text" name="titulo" id="titulo" required /><br /><br />
    <label for="contenido">Contenido:</label><br />
    <textarea name="contenido" id="contenido" rows="6" required></textarea><br /><br />
    <button type="submit">Agregar Comunicado</button>
  </form>

  <h2>Comunicados Existentes</h2>
  <ul>
    <?php while ($row = $result->fetch_assoc()): ?>
      <li><strong><?= htmlspecialchars($row['titulo']) ?></strong> - <?= htmlspecialchars($row['fecha']) ?></li>
    <?php endwhile; ?>
  </ul>
</body>
</html>
<?php $mysqli->close(); ?>
