<?php
//--ini_set('display_errors', 1);
//-- ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Configuración base de datos (modificar con datos reales)
$host = 'localhost:3306';
$usuario = 'ssrlaagu_contactos';
$clave = 'Redhat2025...';
$bd = 'ssrlaagu_contactos';

$mensaje = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // Conectar a base de datos
  $mysqli = new mysqli($host, $usuario, $clave, $bd);
  if ($mysqli->connect_error) {
    die('Error de conexión: ' . $mysqli->connect_error);
  }

  // Recoger y sanitizar datos del formulario
  $nombre = $mysqli->real_escape_string(trim($_POST['nombre']));
  $email = $mysqli->real_escape_string(trim($_POST['email']));
  $tipo = $mysqli->real_escape_string(trim($_POST['tipo']));
  $mensaje_texto = $mysqli->real_escape_string(trim($_POST['mensaje']));
  $fecha = date('Ymd');

  // Obtener correlativo para el día y tipo de requerimiento
  $sql_correlativo = "SELECT COUNT(*) as total FROM contactos WHERE fecha = CURDATE() AND tipo = '$tipo'";
  $resultado = $mysqli->query($sql_correlativo);
  $fila = $resultado->fetch_assoc();
  $correlativo = str_pad($fila['total'] + 1, 4, '0', STR_PAD_LEFT);

  // Número único de atención: fecha + 3 letras tipo + correlativo
  $tipo_abrev = strtoupper(substr($tipo, 0, 3));
  $numero_atencion = $fecha . "-" . $tipo_abrev . "-" . $correlativo;

  // Insertar datos en la tabla contactos
  $stmt = $mysqli->prepare("INSERT INTO contactos (nombre, email, tipo, mensaje, fecha, atencion) VALUES (?, ?, ?, ?, CURDATE(), ?)");
  $stmt->bind_param('sssss', $nombre, $email, $tipo, $mensaje_texto, $numero_atencion);
  $stmt->execute();

  // Enviar email de notificación interna
  $para = "correo@ssrlaaguada.cl"; // Cambiar al correo institucional real
  $asunto = "Nuevo $tipo SSR - Atención Nº $numero_atencion";
  $cuerpo = "Tiene un nuevo $tipo:\n\nNombre: $nombre\nEmail: $email\nMensaje:\n$mensaje_texto\n\nNúmero de Atención: $numero_atencion";

  $cabeceras = "From: no-reply@ssrlaaguada.cl\r\n";
$cabeceras .= "MIME-Version: 1.0\r\n";
$cabeceras .= "Content-type: text/plain; charset=UTF-8\r\n";
  mail($para, $asunto, $cuerpo, $cabeceras);

  $mensaje = "Su requerimiento ha sido registrado con éxito. Su número de atención es: <strong>$numero_atencion</strong>";
  $stmt->close();
  $mysqli->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Contacto - SSR La Aguada</title>
  <link rel="stylesheet" href="css/estilos.css" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
</head>
<body>
  <header class="principal-header">
    <div class="logo-container">
      <img src="img/logo-ssr.png" alt="Logo SSR La Aguada" />
    </div>
    <div class="payment-container">
      <a href="https://laaguada-aproh.geoxite.com/webpay/#no-back-button" class="payment-btn" target="_blank">Botón de Pago</a>
    </div>
    <div class="emergency-container">
      <span><strong>Emergencia:</strong> +56 9 1234 5678<br />Email: emergencia@ssrlaaguada.cl</span>
    </div>
  </header>
  <nav>
    <ul>
      <li><a href="index.html">Home</a></li>
      <li><a href="sobre-nosotros.html">Sobre Nosotros</a></li>
      <li><a href="comunicaciones.html">Comunicaciones</a></li>
      <li><a href="documentos.html">Documentos</a></li>
      <li><a href="contacto.php">Contacto</a></li>
    </ul>
  </nav>
  <main>
    <h1>Formulario de Contacto</h1>
    <?php
    if ($mensaje) {
      echo "<p class='mensaje-exito'>{$mensaje}</p>";
    }
    ?>
    <p> En este formulario puede enviar sus <strong>consultas</strong> o <strong>reclamos</strong> relacionados con el Servicio Sanitario Rural La Aguada. Al enviar su solicitud, recibirá un número único de atención que le permitirá dar seguimiento interno y obtener respuestas de forma ordenada y eficiente. Este sistema facilita la comunicación directa y transparente entre los usuarios y el comité, asegurando que sus requerimientos sean registrados y tratados oportunamente. </p>
    <form method="post" action="contacto.php" autocomplete="off">
      <label for="nombre">Nombre:</label><br />
      <input type="text" id="nombre" name="nombre" required /><br /><br />

      <label for="email">Correo electrónico:</label><br />
      <input type="email" id="email" name="email" required /><br /><br />

      <label for="tipo">Tipo de requerimiento:</label><br />
      <select id="tipo" name="tipo" required>
        <option value="Consulta">Consulta</option>
        <option value="Reclamo">Reclamo</option>
        <option value="Felicitaciones">Felicitaciones</option>
      </select><br /><br />

      <label for="mensaje">Mensaje:</label><br />
      <textarea id="mensaje" name="mensaje" rows="5" required></textarea><br /><br />

      <button type="submit">Enviar</button>
    </form>
  </main>
  <script src="js/script.js"></script>
</body>
</html>
