<?php
session_start();
if (!isset($_SESSION['autenticado']) || $_SESSION['autenticado'] !== true) {
  header('Location: login.php');
  exit;
}

$host = 'localhost:3306';
$usuario = 'ssrlaagu_contactos';
$clave = 'Redhat2025...';
$bd = 'ssrlaagu_contactos';

$mysqli = new mysqli($host, $usuario, $clave, $bd);
if ($mysqli->connect_error) {
  die("Error conexión BD: ".$mysqli->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = intval($_POST['id']);
  $accion = $_POST['accion'] ?? '';

  if ($accion === 'actualizar_estado') {
    $nuevo_estado = $_POST['nuevo_estado'];
    $stmt = $mysqli->prepare("UPDATE contactos SET estado=? WHERE id=?");
    $stmt->bind_param('si', $nuevo_estado, $id);
    $stmt->execute();
    $stmt->close();
  } elseif ($accion === 'subir_pdf' && isset($_FILES['archivo']) && $_FILES['archivo']['error'] === 0) {
    $dir = 'respuestas/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    $nombreArchivo = time().'_'.basename($_FILES['archivo']['name']);
    $rutaArchivo = $dir.$nombreArchivo;
    if (move_uploaded_file($_FILES['archivo']['tmp_name'], $rutaArchivo)) {
      $stmt = $mysqli->prepare("UPDATE contactos SET respuesta_pdf=? WHERE id=?");
      $stmt->bind_param('si', $rutaArchivo, $id);
      $stmt->execute();
      $stmt->close();
    }
  }
}

$result = $mysqli->query("SELECT * FROM contactos ORDER BY fecha DESC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Gestión Formularios SSR La Aguada</title>
  <link rel="stylesheet" href="css/estilos.css" />
  <style>
    table {width:100%;border-collapse: collapse;}
    th,td {border:1px solid #ccc;padding:8px;text-align:left;}
    th {background:#1976d2;color:#fff;}
    .gestionado {background:#d6f5d6;}
    .no-gestionado {background:#f8d7da;}
    body {font-family: Arial, sans-serif;}
    h1 {text-align: center; margin-top: 20px;}
    form {margin: 0;}
  </style>
</head>
<body>
  <h1>Gestión de Formularios</h1>
  <p style="text-align: center;"><a href="logout.php">Cerrar sesión</a></p>
  <table>
    <thead>
      <tr><th>ID Atención</th><th>Nombre</th><th>Email</th><th>Tipo</th><th>Fecha</th><th>Mensaje</th><th>Días transcurridos</th><th>Estado</th><th>Respuesta PDF</th><th>Acciones</th></tr>
    </thead>
    <tbody>
      <?php while ($fila = $result->fetch_assoc()):
        $fechaIngreso = new DateTime($fila['fecha']);
        $fechaHoy = new DateTime();
        $dias = $fechaIngreso->diff($fechaHoy)->days;
        $classEstado = ($fila['estado'] === 'Gestionado') ? 'gestionado' : 'no-gestionado';
        $alerta = ($fila['tipo'] === 'Reclamo' && $fila['estado'] !== 'Gestionado' && $dias > 10) ? 'style="background:#fdd;" title="Reclamo sin gestión > 10 días"' : '';
      ?>
      <tr class="<?= $classEstado ?>" <?= $alerta ?>>
        <td><?= htmlspecialchars($fila['atencion']) ?></td>
        <td><?= htmlspecialchars($fila['nombre']) ?></td>
        <td><?= htmlspecialchars($fila['email']) ?></td>
        <td><?= htmlspecialchars($fila['tipo']) ?></td>
        <td><?= htmlspecialchars($fila['fecha']) ?></td>
        <td><?= nl2br(htmlspecialchars($fila['mensaje'])) ?></td>
        <td><?= $dias ?></td>
        <td><?= htmlspecialchars($fila['estado']) ?></td>
        <td>
          <?php if ($fila['respuesta_pdf']): ?>
            <a href="<?= htmlspecialchars($fila['respuesta_pdf']) ?>" target="_blank">Ver PDF</a>
          <?php else: ?>
            No disponible
          <?php endif; ?>
        </td>
        <td>
          <form method="post" style="margin-bottom:5px;">
            <input type="hidden" name="id" value="<?= $fila['id'] ?>" />
            <input type="hidden" name="accion" value="actualizar_estado" />
            <select name="nuevo_estado" aria-label="Estado gestión">
              <option value="No gestionado" <?= ($fila['estado'] === 'No gestionado') ? 'selected' : '' ?>>No gestionado</option>
              <option value="Gestionado" <?= ($fila['estado'] === 'Gestionado') ? 'selected' : '' ?>>Gestionado</option>
            </select>
            <button type="submit">Actualizar</button>
          </form>
          <form method="post" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?= $fila['id'] ?>" />
            <input type="hidden" name="accion" value="subir_pdf" />
            <input type="file" name="archivo" accept="application/pdf" required />
            <button type="submit">Subir PDF</button>
          </form>
        </td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</body>
</html>

<?php $mysqli->close(); ?>
